#==========================================================================================
# logger_manager.py
#==========================================================================================
# Author: BNW/SoftwareONE
#==========================================================================================
#
# Description:
# Contains backend implementation for logger module. Adapted from original code by Crest.
#
#==========================================================================================

#==========================================================================================
# Dependencies
#==========================================================================================

from __future__ import print_function
from builtins import str
import logging
import logging.handlers
import os

#==========================================================================================

def setup_logging(log_name, log_level=None, log_path=None, max_bytes=10485760, backup_count=10, log_format=None):
    if log_path is None:
        log_path = os.path.join(os.path.dirname(os.path.abspath(__file__)), '..', "log")
    log_file = os.path.join(log_path, "%s.log" % log_name)
    logdir = os.path.dirname(log_file)
    if not os.path.exists(logdir):
        os.makedirs(logdir)
    logger = logging.getLogger(log_name)
    logger.propagate = False

    if log_level is None:
        log_level = logging.ERROR
    else:
        log_level = logging._nameToLevel[log_level.strip().upper()]

    logger.setLevel(log_level)

    handler_exists = any([True for h in logger.handlers
                          if h.baseFilename == log_file])
    if not handler_exists:
        file_handler = logging.handlers.RotatingFileHandler(log_file, mode="a",
                                                            maxBytes=max_bytes,
                                                            backupCount=backup_count)

        fmt_str = log_format
        if fmt_str is None:
            fmt_str = "%(asctime)s %(levelname)s %(thread)d - %(message)s"

        formatter = logging.Formatter(fmt_str)
        file_handler.setFormatter(formatter)
        logger.addHandler(file_handler)
        file_handler.setLevel(log_level)
        return logger
